/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.utils;

import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.utils.IVWAppLauncher;
import filenet.vw.toolkit.utils.IVWFrameInterface;
import filenet.vw.toolkit.utils.IVWLaunchableApp;
import filenet.vw.toolkit.utils.VWWindowAdapter;
import java.awt.Window;
import java.awt.event.WindowEvent;
import java.util.Vector;
import javax.swing.JFrame;

class VWChildAppManager
implements IVWAppLauncher,
IVWFrameInterface {
    private IVWAppLauncher m_parentApp = null;
    private Vector m_activeApplications = null;
    private VWWindowAdapter m_windowAdapter = null;

    public VWChildAppManager(IVWAppLauncher parentApp) {
        this.m_parentApp = parentApp;
    }

    public void registerApplication(IVWLaunchableApp childApp) {
        if (childApp != null && childApp instanceof Window) {
            if (this.m_windowAdapter == null) {
                this.m_windowAdapter = new VWWindowAdapter(this);
            }
            ((Window)((Object)childApp)).addWindowListener(this.m_windowAdapter);
            if (this.m_activeApplications == null) {
                this.m_activeApplications = new Vector();
            }
            this.m_activeApplications.addElement(childApp);
        }
    }

    public boolean hasChildClass(String className) {
        return this.findChildApplication(className) != null;
    }

    public boolean bringChildAppToFront(String className) {
        IVWLaunchableApp childApp = this.findChildApplication(className);
        if (childApp != null) {
            return this.displayChildApp(childApp);
        }
        return false;
    }

    public void windowClosing(WindowEvent event) {
        try {
            Window app;
            if (this.m_activeApplications == null) {
                return;
            }
            if (event != null && event.getWindow() != null && (app = event.getWindow()) instanceof IVWLaunchableApp && !app.isShowing()) {
                this.m_activeApplications.removeElement(app);
                if (this.m_parentApp != null) {
                    this.m_parentApp.windowClosing(event);
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    protected boolean closeChildApplications() {
        try {
            if (!this.hasChildren()) {
                return true;
            }
            for (int nIndex = this.m_activeApplications.size() - 1; nIndex >= 0; --nIndex) {
                IVWLaunchableApp childApp = (IVWLaunchableApp)this.m_activeApplications.elementAt(nIndex);
                if (!(childApp instanceof Window)) continue;
                this.displayChildApp(childApp);
                WindowEvent event = new WindowEvent((Window)((Object)childApp), 201);
                childApp.windowClosing(event);
                if (((Window)((Object)childApp)).isShowing()) continue;
                this.windowClosing(event);
            }
            return this.m_activeApplications.isEmpty();
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            return false;
        }
    }

    protected boolean hasChildren() {
        return this.m_activeApplications != null && this.m_activeApplications.size() > 0;
    }

    protected boolean displayChildApp(IVWLaunchableApp childApp) {
        if (childApp != null && childApp instanceof JFrame) {
            ((JFrame)((Object)childApp)).setState(0);
            if (childApp instanceof Window) {
                ((Window)((Object)childApp)).setVisible(true);
            }
            return true;
        }
        return false;
    }

    protected IVWLaunchableApp findChildApplication(String className) {
        try {
            if (!this.hasChildren()) {
                return null;
            }
            for (int nIndex = 0; nIndex < this.m_activeApplications.size(); ++nIndex) {
                IVWLaunchableApp childApp = (IVWLaunchableApp)this.m_activeApplications.elementAt(nIndex);
                if (!(childApp instanceof Window) || !childApp.getClass().getName().equals(className)) continue;
                return childApp;
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return null;
    }
}

